"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.request = request;
const axios_1 = __importDefault(require("axios"));
function request(options, callback) {
    console.log("axiosRequest called with options:", options);
    const method = (options.method || 'GET').toLowerCase();
    console.log("Method:", method);
    const config = {
        method: method,
        url: options.url || '',
        headers: options.headers || {},
        params: options.params || options.qs,
        validateStatus: () => true
    };
    // Handle auth if provided
    if (options.auth) {
        config.auth = {
            username: options.auth.user,
            password: options.auth.pass
        };
    }
    // Handle form data
    if (options.form) {
        config.data = options.form;
        config.headers = { ...config.headers, 'Content-Type': 'application/x-www-form-urlencoded' };
    }
    else if (options.body && ['post', 'put', 'patch', 'delete'].includes(method)) {
        if (typeof options.body === 'string') {
            try {
                config.data = JSON.parse(options.body);
            }
            catch (error) {
                console.error("JSON parse error for body:", options.body);
                console.error("Parse error:", error.message);
                // If JSON parsing fails, send the raw string as data
                config.data = options.body;
                // Set appropriate content type for raw string data
                config.headers = { ...config.headers, 'Content-Type': 'text/plain' };
            }
        }
        else {
            config.data = options.body;
        }
        console.log("Config data (body):", config.data);
    }
    console.log("Axios config:", config);
    (0, axios_1.default)(config)
        .then((response) => {
        console.log("Axios response received:", response.status, response.data);
        const res = {
            statusCode: response.status,
            headers: response.headers,
            body: JSON.stringify(response.data)
        };
        // if (options.log) {
        //   console.log(`[AxiosRequest] ${method.toUpperCase()} ${options.url} -> ${res.statusCode}`);
        // }
        console.log("Callback with response:", res);
        // Always call with 3 parameters to match request package behavior
        callback(null, res, res.body);
    })
        .catch((error) => {
        console.error("Axios request error:", error.message);
        // if (options.log) {
        //   console.error(`[AxiosRequest] ERROR: ${method.toUpperCase()} ${options.url}`, error.message);
        // }
        // Always call with 3 parameters to match request package behavior
        callback(error, undefined, undefined);
    });
}
